//
//  Expander.fsh
//  AOFExpander
//
//  Created by AOIDC on 2015/06/22.
//  Copyright (c) 2015 AOIDC. All rights reserved.
//

#if 0   // OpenGL ES
precision mediump float;
varying vec2 vTextureCoord;
#else
varying vec2 vTextureCoord;
#endif

const mat4 Rgb2Yuv = mat4(
    0.299,  0.587,  0.114,  0.000,
   -0.169, -0.332,  0.500,  0.000,
    0.500, -0.419, -0.081,  0.000,
    0.000,  0.000,  0.000,  1.000
);

const mat4 Yuv2Rgb = mat4(
    1.000,  0.000,  1.402,  0.000,
    1.000, -0.344, -0.714,  0.000,
    1.000,  1.772,  0.000,  0.000,
    0.000,  0.000,  0.000,  1.000
);

uniform float fSharpness[9];
uniform float fBrightness;
uniform float fContrast;
uniform float fSaturation;
uniform float fAlpha;
uniform float fTexWidth;
uniform float fTexHeight;
uniform int   iFlagLine;
uniform vec4  vColor;
uniform sampler2D sTexture;

#define KERNEL_SIZE 9

float step_w = 1.0 / (fTexWidth * 8.0);
float step_h = 1.0 / (fTexHeight * 8.0);
vec2 offset[KERNEL_SIZE];

// draw line
void drawLine()
{
    gl_FragColor = vec4(vColor);
}

// draw Image
void drawImage()
{
    vec4 rgba;
    vec4 yuv;
    float basealpha;
    vec2 uv = vTextureCoord.st;

    if ((uv.s < 0.0) || (uv.s > 1.0) || (uv.t < 0.0) || (uv.t > 1.0)) {
        gl_FragColor = vec4(0.0, 0.0, 0.0, 1.0); 
    } else {
        // Sharpness
        int i = 0;
        vec4 sum = vec4(0.0);
	   
        offset[0] = vec2(-step_w, -step_h);
        offset[1] = vec2(0.0, -step_h);
        offset[2] = vec2(step_w, -step_h);
	   
        offset[3] = vec2(-step_w, 0.0);
        offset[4] = vec2(0.0, 0.0);
        offset[5] = vec2(step_w, 0.0);
	   
        offset[6] = vec2(-step_w, step_h);
        offset[7] = vec2(0.0, step_h);
        offset[8] = vec2(step_w, step_h);
    
        for( i=0; i<KERNEL_SIZE; i++ )
        {
            vec4 tmp = texture2D(sTexture, vTextureCoord.st + offset[i]);
            sum += tmp * fSharpness[i];
            if (i == 4) basealpha = tmp.a;
        }
    
        rgba.rgb = sum.rgb;

        // RGB to YUV
#if 0
        yuv = vec4(rgba * Rgb2Yuv);
#else
        yuv = vec4(rgba.r*(0.299) +rgba.g*(0.587) +rgba.b*(0.114),
                   rgba.r*(-0.169)+rgba.g*(-0.332)+rgba.b*(0.5),
                   rgba.r*(0.5)   +rgba.g*(-0.419)+rgba.b*(-0.081),
                   rgba.a);
#endif
        // Saturation
        yuv.y *= fSaturation;
        yuv.z *= fSaturation;
        yuv.w = fAlpha;
        // YUV to RGB
#if 0
        rgba = (yuv * Yuv2Rgb);
#else
        rgba = vec4(yuv.x               +yuv.z*(1.402),
                    yuv.x+yuv.y*(-0.344)+yuv.z*(-0.714),
                    yuv.x+yuv.y*(1.772),
                    yuv.w);
#endif
        // Contrast
        rgba.r = (((rgba.r - 0.5) * fContrast) + 0.5);
        rgba.g = (((rgba.g - 0.5) * fContrast) + 0.5);
        rgba.b = (((rgba.b - 0.5) * fContrast) + 0.5);
        // Brightness
        rgba.r += (fBrightness - 0.5);
        rgba.g += (fBrightness - 0.5);
        rgba.b += (fBrightness - 0.5);
        rgba.a = basealpha * fAlpha;
        gl_FragColor = vec4(rgba);
    }
}
    
void main()
{
    if (iFlagLine == 1) {
        drawLine();
    } else {
        drawImage();
    }
}
